/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8285.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8285.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8285.DeviceView.DefaultStatus;
import ibm.nways.jdm8285.DeviceView.PortLike;
import ibm.nways.jdm8285.DeviceView.StatusRefLike;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.WidgetCookie;

public class Port
implements PortLike,
StatusRefLike {
    protected int slot;
    protected int portNumber;
    protected int portType;
    protected GraphicImage portGraphicImage;
    protected GraphicContainer graphicContainer;
    protected String cookieID;
    protected ChassisInfoLike chassisInfo;
    protected String destinationPanel;
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8285.DeviceView.GraphicResources";
    protected static final String SER_PATH = "ibm.nways.jdm8285.WCDefault";
    protected static final int COOKIE_FLAGS = 28;
    protected static final int COOKIE_FLAGS_NO_ACTION = 30;
    protected Status statusRef;
    protected GenModel portModel;
    public static final int RJ45 = 0;
    public static final int FC = 1;
    public static final int BNC = 2;
    public static final int AUI_MALE = 3;
    public static final int MAUI = 3;
    public static final int AUI_FEMALE = 4;
    public static final int FAUI = 4;
    public static final int TELCO = 5;
    public static final int FDDI = 6;
    public static final int DB9 = 7;
    public static final int RS232 = 8;
    public static final int ATM155 = 9;
    public static final int A8MPEG = 10;
    public static final int A04MBBRG = 11;
    public static final int A8229ETH = 12;
    public static final int A8229TRI = 13;
    public static final int A8235PORT = 14;
    public static final int FDDI_DOUBLE = 15;
    public static final int LOGICAL_12 = 16;
    public static final int LOGICAL_16 = 17;
    public static final int SC = 18;
    public static final int LOGICAL_E1 = 19;
    public static final int MIC = 20;
    protected static final String[] PORT_TYPE = new String[]{"Port_rj45", "Port_fiber", "Port_bnc", "Port_aui", "Port_aui", "Port_telco", "Port_fddi", "Port_db9", "Port_rs232", "Port_rj45", "Port_bnc", "Port_rj45", "Port_rj45", "Port_rj45", "Port_rj45", "Port_fddi", "Port_rj45", "Port_rj45", "Port_sc", "Port_db9", "Port_mic"};
    protected static final String[] IF_CONNECTOR_TYPE = new String[]{"", "Unknown", "Internal", "MIC", "SC", "Monomode", "DB-9", "RJ45", "BNC", "DB-15"};
    protected static final String[] IF_MEDIA_TYPE = new String[]{"", "Unknown", "SMF", "MMF", "TP", "UTP", "STP", "Coaxial", "Backplane", "Long Range Fiber", "Unspecified Fiber"};

    public void dispose() {
        this.portModel = null;
        this.graphicContainer.dispose();
        this.graphicContainer = null;
        this.portGraphicImage.dispose();
        this.portGraphicImage = null;
        this.chassisInfo = null;
        this.statusRef = null;
        this.cookieID = null;
        this.destinationPanel = null;
    }

    public void setStatusRef(Status status) {
        this.statusRef = status;
    }

    public Status getStatusRef() {
        return this.statusRef;
    }

    public final void setCommonInformation(ChassisInfoLike chassisInfoLike, String string, int n, int n2, int n3, GraphicContainer graphicContainer, String string2, GenModel genModel) {
        this.chassisInfo = chassisInfoLike;
        this.cookieID = string;
        this.slot = n;
        this.portNumber = n2;
        this.portType = n3;
        this.graphicContainer = graphicContainer;
        this.portModel = genModel;
        this.destinationPanel = string2;
    }

    public void setSpecificInformation() {
    }

    public void draw() {
        String string = "draw";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string);
        }
        WidgetCookie widgetCookie = null;
        ModelInfo modelInfo = this.getModelInfo();
        if (RAS.isEnabled(19, 6)) {
            RAS.trace(19, 6, this, string, "Creating new port WidgetCookie. Slot:" + this.slot + " Port:" + this.portNumber);
        }
        int n = this.getDestinationPanel() == null ? 30 : 28;
        widgetCookie = new WidgetCookie(this.cookieID, BUNDLE_NAME, modelInfo, SER_PATH, this.portModel, this.chassisInfo.getBrowser(), n, this.getDestinationPanel());
        this.portGraphicImage = widgetCookie.GetImage();
        I18NMsgFormat i18NMsgFormat = this.getFlyOverText();
        this.statusRef = DefaultStatus.getDefaultStatus();
        this.portGraphicImage.setStatus(this.statusRef);
        if (this.portModel != null) {
            this.chassisInfo.askStatus(this.portModel, this.portGraphicImage, modelInfo, this);
        }
        this.portGraphicImage.setFlyOver(new GraphicFlyOver(i18NMsgFormat.getTranslation()));
        this.graphicContainer.add((GraphicContainer)widgetCookie);
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string);
        }
    }

    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.InterfaceIndex", new Integer(this.slot * 100 + this.portNumber));
        return modelInfo;
    }

    public GenModel getGenModel() {
        return this.portModel;
    }

    public String getDestinationPanel() {
        return this.destinationPanel;
    }

    public I18NMsgFormat getFlyOverText() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(this.portNumber);
        String string = "Port_unspecified_conn";
        try {
            string = PORT_TYPE[this.portType];
        }
        catch (Exception exception) {
            RAS.logWarning(19, 6, this, "getFlyOverText", "Cannot find fly-over for port type -> " + this.portType);
        }
        objectArray[1] = this.chassisInfo.getBundle().getString(string);
        return new I18NMsgFormat(BUNDLE_NAME, "Port", objectArray);
    }

    public GraphicImage getGraphicImage() {
        return this.portGraphicImage;
    }

    public String getIfConnectorString(int n) {
        String string = "";
        try {
            string = IF_CONNECTOR_TYPE[n];
        }
        catch (Exception exception) {
            RAS.logWarning(19, 6, this, "getIfConnectorString", "Cannot find the Interface Connector " + n);
        }
        return string;
    }

    public String getIfMediaTypeString(int n) {
        String string = "";
        try {
            string = IF_MEDIA_TYPE[n];
        }
        catch (Exception exception) {
            RAS.logWarning(19, 6, this, "getIfMediaTypeString", "Cannot find the Interface Media Type " + n);
        }
        return string;
    }

    public String toString() {
        return "Slot -> " + this.slot + " portNumber -> " + this.portNumber;
    }
}

